package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.BufferedWriter;

public class ExportablePaletteObject extends PaletteObject {
	
	
	private String [] outputData;
	
	public ExportablePaletteObject(IntRect theRect, CustomImageDataII theImage, int theDistanceToBorder, int theBorderWidth, RoomEditorPanel rep, String [] theOutputData) {
		image = theImage;
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
		outputData = theOutputData;
		
		isSelected = false;
		editorPanel = rep;
		
		clickRect = theRect;
	}
	
	
	@Override
	public void draw(Graphics g) {
		
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
		if(image == null) {
			
		} else {
			image.drawObjectIgnoreBounds(g, p.x, p.y);
		}
		

		Color origCol = g.getColor();
		
		if(isSelected) {
			
			g.setColor(new Color(0, 255, 200));
			
		} else {
			g.setColor(new Color(0, 50, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
		
		
	}
	
	
	
	public void write(BufferedWriter out) throws Exception {
		
		for(String s : outputData) {
			out.write(s);
			out.newLine();
		}
		
		out.newLine();
		
	}
	
	
	public void setClickRect(IntRect theRect) {
		clickRect = theRect;
	}
	
	public String[] getOutputArray() {
		return outputData;
	}
	
}
